#ifndef __SIMMSGHEAP_H__
#define __SIMMSGHEAP_H__

#include "cSimInfo.h"

class cSimMsgHeap
{

 protected:

 public:
	
	//Constructor(s)
	cSimMsgHeap(unsigned int initialCap, unsigned int capInc);	

	//Destructor
	~cSimMsgHeap();

	//Public Functions
	bool	Clear();				// Clears the heap.
	int		GetNumElements();

	bool		 Peek(SimMsg* msg);		// Peeks at the head of the queue.
	bool		 Remove(SimMsg* msg);
	bool		 Insert(SimMsg* msg);	// Inserts a message into the heap.

 private:
	bool _Grow();	// Attempts to grow the heap by at least one element, at most capInc
	bool _Exchange(unsigned int a, unsigned int b);
	bool _Heapify(unsigned int index);	// Recreates the heap starting at the given index
	unsigned int _Parent(unsigned int index) { return (index-1) >> 1; }
	unsigned int _Left(unsigned int index)	 { return (index << 1)+1; }
	unsigned int _Right(unsigned int index)  { return (index << 1)+2; }

	//Member Vars
	SimMsg*		  mQueue;
	unsigned int  mHeapSize;
	unsigned int  mSize;
	unsigned int  mCapIncrement;
};

#endif
